function[Z,P] = LINMUD(X) 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% MATLAB code: Exercise 6.9(a) 
% File: Exercise_6-9.m
%
% Purpose: Provide the Lin-Mudholkar statistic to test the 
%          assumption that the input N*1 data vector X is normally
%          distributed 
% Input:   X = data; 
% Output:  Z-statistic 
%          P-value
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N = length(X);
for I=1:N 
   T     = X(I); 
   X(I)  = 0;  
   BX(I) = mean(X);
   R(I)  = dot(X,X); 
   V(I)  = R(I)-(BX(I)*BX(I)/(N-1))*N*N; 
   V(I)  = V(I)/N; 
   ILS   = 1; 
   if V(I) < 0
     ILS = -1;
   end
   V(I) = ILS*V(I); 
   if V(I) == 0
     V(I) = 0;
   else
     V(I) = V(I)^(0.333333); 
     V(I) = ILS*V(I); % V = cube root of 
%           (Nth of (SS of X)-(N-1)th of (SS of X))    
   end
   Y(I)   = V(I); 
   X(I)   = T;    
end
Rcorr = corrcoef(X,Y);
R     = Rcorr(1,2);
Z2    = 0.5*log((1+R)/(1-R));
Z     = Z2/sqrt(3/N);  % Z = asymptotically N(0,1) distributed
P     = 1-normcdf(Z,0,1);  